/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.model.resource;

import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.LazyLogging$class;
import com.typesafe.scalalogging.slf4j.Logger;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import rpgboss.model.resource.Music;
import rpgboss.model.resource.MusicPlayer;
import rpgboss.model.resource.MusicPlayer$class;
import rpgboss.player.FloatTweener;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u0013\tyQ*\u001b3j\u001bV\u001c\u0018n\u0019)mCf,'O\u0003\u0002\u0004\t\u0005A!/Z:pkJ\u001cWM\u0003\u0002\u0006\r\u0005)Qn\u001c3fY*\tq!A\u0004sa\u001e\u0014wn]:\u0004\u0001M!\u0001A\u0003\n\u0017!\tY\u0001#D\u0001\r\u0015\tia\"\u0001\u0003mC:<'\"A\b\u0002\t)\fg/Y\u0005\u0003#1\u0011aa\u00142kK\u000e$\bCA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005-iUo]5d!2\f\u00170\u001a:\u0011\u0005]\u0001S\"\u0001\r\u000b\u0005eQ\u0012!B:mMRR'BA\u000e\u001d\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tib$\u0001\u0005usB,7/\u00194f\u0015\u0005y\u0012aA2p[&\u0011\u0011\u0005\u0007\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003\u0015iWo]5d!\t\u0019R%\u0003\u0002'\u0005\t)Q*^:jG\")\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"\"AK\u0016\u0011\u0005M\u0001\u0001\"B\u0012(\u0001\u0004!\u0003BC\u0017\u0001!\u0003\u0005\u0019\u0011)A\u0005]\u0005\u0019\u0001\u0010J\u0019\u0011\t=\u0012DGP\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1A+\u001e9mKJ\u0002\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\t5LG-\u001b\u0006\u0003si\nQa]8v]\u0012T\u0011aO\u0001\u0006U\u00064\u0018\r_\u0005\u0003{Y\u0012\u0011bU3rk\u0016t7-\u001a:\u0011\u0005Uz\u0014B\u0001!7\u0005-\u0019\u0016P\u001c;iKNL'0\u001a:\t\u000f\t\u0003!\u0019!C\u0001\u0007\u0006I1/Z9vK:\u001cWM]\u000b\u0002i!1Q\t\u0001Q\u0001\nQ\n!b]3rk\u0016t7-\u001a:!\u0011\u001d9\u0005A1A\u0005\u0002!\u000b1b]=oi\",7/\u001b>feV\ta\b\u0003\u0004K\u0001\u0001\u0006IAP\u0001\rgftG\u000f[3tSj,'\u000f\t\u0005\b\u0019\u0002\u0001\r\u0011\"\u0003N\u0003\u001dyfo\u001c7v[\u0016,\u0012A\u0014\t\u0003_=K!\u0001\u0015\u0019\u0003\u000b\u0019cw.\u0019;\t\u000fI\u0003\u0001\u0019!C\u0005'\u0006YqL^8mk6,w\fJ3r)\t!v\u000b\u0005\u00020+&\u0011a\u000b\r\u0002\u0005+:LG\u000fC\u0004.#\u0006\u0005\t\u0019\u0001(\t\re\u0003\u0001\u0015)\u0003O\u0003!yfo\u001c7v[\u0016\u0004\u0003bB.\u0001\u0005\u0004%\t\u0001X\u0001\tg\u0016\fX/\u001a8dKV\tQ\f\u0005\u00026=&\u0011qL\u000e\u0002\t'\u0016\fX/\u001a8dK\"1\u0011\r\u0001Q\u0001\nu\u000b\u0011b]3rk\u0016t7-\u001a\u0011\t\u000b\r\u0004A\u0011\u00013\u0002\u0013\u001d,GOV8mk6,G#\u0001(\t\u000b\u0019\u0004A\u0011A4\u0002\u0013M,GOV8mk6,GC\u0001+i\u0011\u0015IW\r1\u0001O\u0003%qWm\u001e,pYVlW\rC\u0003l\u0001\u0011\u0005A.A\u0003qCV\u001cX\rF\u0001U\u0011\u0015q\u0007\u0001\"\u0001m\u0003\u0011\u0001H.Y=\t\u000bA\u0004A\u0011A9\u0002\u0015M,G\u000fT8pa&tw\r\u0006\u0002Ue\")1o\u001ca\u0001i\u0006!An\\8q!\tyS/\u0003\u0002wa\t9!i\\8mK\u0006t\u0007\"\u0002=\u0001\t\u0003a\u0017\u0001B:u_BDQA\u001f\u0001\u0005\u00021\fq\u0001Z5ta>\u001cX\r")
public class MidiMusicPlayer
implements MusicPlayer,
LazyLogging {
    private final Music music;
    private final /* synthetic */ Tuple2 x$1;
    private final Sequencer sequencer;
    private final Synthesizer synthesizer;
    private float _volume;
    private final Sequence sequence;
    private final Logger logger;
    private final FloatTweener volumeTweener;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        MidiMusicPlayer midiMusicPlayer = this;
        synchronized (midiMusicPlayer) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public FloatTweener volumeTweener() {
        return this.volumeTweener;
    }

    @Override
    public void rpgboss$model$resource$MusicPlayer$_setter_$volumeTweener_$eq(FloatTweener x$1) {
        this.volumeTweener = x$1;
    }

    @Override
    public void update(float delta) {
        MusicPlayer$class.update(this, delta);
    }

    public Sequencer sequencer() {
        return this.sequencer;
    }

    public Synthesizer synthesizer() {
        return this.synthesizer;
    }

    private float _volume() {
        return this._volume;
    }

    private void _volume_$eq(float x$1) {
        this._volume = x$1;
    }

    public Sequence sequence() {
        return this.sequence;
    }

    @Override
    public float getVolume() {
        return this._volume();
    }

    @Override
    public void setVolume(float newVolume) {
        this._volume_$eq(newVolume);
        int midiVolume = (int)((double)newVolume * 127.0);
        Predef$.MODULE$.refArrayOps((Object[])this.synthesizer().getChannels()).foreach(new Serializable(this, midiVolume){
            private final int midiVolume$1;

            public final void apply(MidiChannel channel) {
                channel.controlChange(7, this.midiVolume$1);
            }
            {
                this.midiVolume$1 = midiVolume$1;
            }
        });
    }

    @Override
    public void pause() {
        BoxedUnit boxedUnit;
        if (this.sequencer() != null && this.sequencer().isOpen()) {
            this.sequencer().stop();
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("MIDI sequencer null or not open");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void play() {
        BoxedUnit boxedUnit;
        if (this.sequencer() != null && this.sequencer().isOpen()) {
            this.sequencer().start();
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("MIDI sequencer null or not open");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void setLooping(boolean loop2) {
        BoxedUnit boxedUnit;
        if (this.sequencer() != null && this.sequencer().isOpen()) {
            int count2 = loop2 ? -1 : 0;
            this.sequencer().setLoopCount(count2);
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("MIDI sequencer null or not open");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void stop() {
        BoxedUnit boxedUnit;
        if (this.sequencer() != null && this.sequencer().isOpen()) {
            this.sequencer().stop();
            this.sequencer().setTickPosition(0L);
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn("MIDI sequencer null or not open");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void dispose() {
        this.stop();
        if (this.sequencer() != null) {
            this.sequencer().close();
        }
    }

    private final Tuple2 liftedTree1$1() {
        Tuple2<Sequencer, Synthesizer> tuple2;
        try {
            Sequencer sequencer = MidiSystem.getSequencer(false);
            Synthesizer synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            sequencer.getTransmitter().setReceiver(synthesizer.getReceiver());
            tuple2 = new Tuple2<Sequencer, Synthesizer>(sequencer, synthesizer);
        }
        catch (Throwable throwable2) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringOps(Predef$.MODULE$.augmentString("Could not initialize MIDI sequencer: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{throwable2.getMessage()})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            tuple2 = null;
        }
        return tuple2;
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence liftedTree2$1() {
        Sequence sequence2;
        try {
            void var1_1;
            Sequence s2 = MidiSystem.getSequence(this.music.newDataStream());
            if (this.sequencer() != null) {
                this.sequencer().open();
                this.setVolume(0.0f);
                this.sequencer().setSequence(s2);
            }
            sequence2 = var1_1;
        }
        catch (Throwable throwable2) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Could not initialize MIDI sequence");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            sequence2 = null;
        }
        return sequence2;
    }

    public MidiMusicPlayer(Music music) {
        this.music = music;
        MusicPlayer$class.$init$(this);
        LazyLogging$class.$init$(this);
        Tuple2 tuple2 = this.liftedTree1$1();
        if (tuple2 != null) {
            Sequencer sequencer = (Sequencer)tuple2._1();
            Synthesizer synthesizer = (Synthesizer)tuple2._2();
            if (sequencer != null) {
                Sequencer sequencer2 = sequencer;
                if (synthesizer != null) {
                    Tuple2<Sequencer, Synthesizer> tuple22;
                    Synthesizer synthesizer2 = synthesizer;
                    this.x$1 = tuple22 = new Tuple2<Sequencer, Synthesizer>(sequencer2, synthesizer2);
                    this.sequencer = (Sequencer)this.x$1._1();
                    this.synthesizer = (Synthesizer)this.x$1._2();
                    this._volume = 0.0f;
                    this.sequence = this.liftedTree2$1();
                    return;
                }
            }
        }
        throw new MatchError(tuple2);
    }
}

